/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package ihm.iprinewsanalyzer;

import javax.swing.JDialog;
import javax.swing.text.html.HTMLEditorKit;

import java.awt.Dimension;

import java.io.FileNotFoundException;
import java.io.IOException;

import java.net.URL;

public class DialogueHTML extends JDialog {

    /** Creates new form DialogueHTML */
    public DialogueHTML() {
        initComponents();
        jEditorPane1.setEditorKit(new HTMLEditorKit());
        jEditorPane1.setPreferredSize(new Dimension(400,400));
        pack();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        jLabel1 = new javax.swing.JLabel();
        jScrollPane2 = new javax.swing.JScrollPane();
        jEditorPane1 = new javax.swing.JEditorPane();

        jScrollPane1.setName("jScrollPane1"); // NOI18N

        setName("Form"); // NOI18N

        org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(zold.ihm.ipriproto._IHMTest1App.class).getContext().getResourceMap(DialogueHTML.class);
        jLabel1.setText(resourceMap.getString("jLabel1.text")); // NOI18N
        jLabel1.setName("jLabel1"); // NOI18N
        getContentPane().add(jLabel1, java.awt.BorderLayout.PAGE_START);

        jScrollPane2.setName("jScrollPane2"); // NOI18N

        jEditorPane1.setBackground(resourceMap.getColor("jEditorPane1.background")); // NOI18N
        jEditorPane1.setEditable(false);
        jEditorPane1.setName("jEditorPane1"); // NOI18N
        jScrollPane2.setViewportView(jEditorPane1);

        getContentPane().add(jScrollPane2, java.awt.BorderLayout.CENTER);

        pack();
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JEditorPane jEditorPane1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    // End of variables declaration//GEN-END:variables

    public void setPage(final URL url){
        new Thread() {
            public void run() {
                jLabel1.setText(url.toString());
                try {
                    jEditorPane1.setPage(url);
                } catch (FileNotFoundException ioe) {
                    jEditorPane1.setText("Erreur 404 - Cette page n'existe pas.");
                } catch (IOException ioe) {
                    ioe.printStackTrace();
                    jEditorPane1.setText("Erreur - Cette page ne peut pas être affichée.");
                }

            }
        }.start();
        setVisible(true);
        requestFocus();
    }
}
